/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server;

import ch.uyuno.printcontrol.server.CommunicationManager;
import ch.uyuno.serialinterface.Frame;
import java.util.concurrent.Semaphore;

public class ComunicationObject {
    private static final int BUFFERSIZE = 512;
    private CommunicationManager m;
    private byte[] requestBuffer = new byte[512];
    private int requestSize;
    private byte[] anserBuffer = new byte[512];
    private int anserSize;
    private Semaphore semaphore = new Semaphore(0);

    public ComunicationObject(byte addres) {
        this.m = CommunicationManager.getManager();
        this.requestBuffer[0] = addres;
    }

    public ComunicationObject clone() {
        return new ComunicationObject(this.requestBuffer[0]);
    }

    public void setRequest(byte[] buf, int size) {
        int y = size < 512 ? size : 511;
        int i = 0;
        while (i < y) {
            this.requestBuffer[i + 1] = buf[i];
            ++i;
        }
        this.requestSize = 1 + y;
    }

    public Frame getRequestFrame() {
        return new Frame(this.requestBuffer, this.requestSize);
    }

    public void setAnserFrame(Frame f) {
        this.anserSize = 0;
        if (f != null && f.GetFrameSize() > 1 && f.GetFrameSize() <= 512) {
            int i = 0;
            while (i < f.GetFrameSize()) {
                this.anserBuffer[i] = f.GetFrameBuffer()[i];
                ++i;
            }
            this.anserSize = f.GetFrameSize();
        }
        this.semaphore.release();
    }

    public byte[] getAnser() {
        byte[] result = null;
        if (this.anserSize > 1 && this.anserSize <= 512) {
            result = new byte[this.anserSize - 1];
            int i = 0;
            while (i < this.anserSize - 1) {
                result[i] = this.anserBuffer[i + 1];
                ++i;
            }
        }
        return result;
    }

    public byte getAddres() {
        return this.requestBuffer[0];
    }

    public byte getAnserAddres() {
        return this.anserBuffer[0];
    }

    public void setAddres(byte addres) {
        this.requestBuffer[0] = addres;
    }

    public boolean isPortOpen() {
        return this.m.isPortOpen();
    }

    public boolean blockTransfer() {
        return this.m.blockTransfer();
    }

    public void Prozess() throws InterruptedException {
        if (this.m != null) {
            this.m.Process(this);
            this.semaphore.acquire();
        }
    }
}

