/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.data;

import ch.uyuno.printcontrol.data.Activator;
import ch.uyuno.printcontrol.data.Application;
import ch.uyuno.printcontrol.data.Machine;
import ch.uyuno.printcontrol.data.Parameter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Utilities {
    private static Object obj = null;
    private static XStream xstream = null;

    public static boolean saveStringToFile(String fileName, String saveString) {
        boolean saved = false;
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fileName));
            try {
                bw.write(saveString);
                saved = true;
            }
            finally {
                bw.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return saved;
    }

    public static String getStringFromFile(String fileName) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new FileReader(fileName));
            try {
                String s;
                while ((s = br.readLine()) != null) {
                    sb.append(s);
                    sb.append("\n");
                }
            }
            finally {
                br.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static String convertMachineToXML(Machine ml) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("Machine", Machine.class);
        xstream.alias("Application", Application.class);
        xstream.alias("Parameter", Parameter.class);
        return xstream.toXML((Object)ml);
    }

    public static Machine convertMachineFromXML(String XMLString) {
        Machine ml = null;
        xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.setClassLoader(Activator.class.getClassLoader());
        xstream.alias("Machine", Machine.class);
        xstream.alias("Application", Application.class);
        xstream.alias("Parameter", Parameter.class);
        try {
            obj = xstream.fromXML(XMLString);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (obj instanceof Machine) {
            ml = (Machine)obj;
        }
        return ml;
    }

    public static String convertApplicationToXML(Application a) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("Application", Application.class);
        xstream.alias("Parameter", Parameter.class);
        return xstream.toXML((Object)a);
    }

    public static Application convertApplicationFromXML(String XMLString) {
        Application a = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.setClassLoader(Activator.class.getClassLoader());
        xstream.alias("Application", Application.class);
        xstream.alias("Parameter", Parameter.class);
        Object obj = xstream.fromXML(XMLString);
        if (obj instanceof Application) {
            a = (Application)obj;
        }
        return a;
    }

    public static boolean saveMachineToXMLFile(String fileName, Machine ml) {
        return Utilities.saveStringToFile(fileName, Utilities.convertMachineToXML(ml));
    }

    public static Machine getMachineFromXMLFile(String fileName) {
        return Utilities.convertMachineFromXML(Utilities.getStringFromFile(fileName));
    }
}

