/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.actions;

import ch.uyuno.printcontrol.server.ApplicationEntry;
import ch.uyuno.printcontrol.server.DataAccess;
import ch.uyuno.printcontrol.server.Messages;
import ch.uyuno.printcontrol.server.dialog.RenameDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class RenameApplicationAction
extends BaseSelectionListenerAction {
    private DataAccess data = null;

    public RenameApplicationAction(String text, DataAccess data) {
        super(text);
        this.data = data;
    }

    public final void run() {
        if (this.getStructuredSelection().getFirstElement() instanceof ApplicationEntry && this.data != null) {
            ApplicationEntry a = (ApplicationEntry)this.getStructuredSelection().getFirstElement();
            RenameDialog rd = new RenameDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            rd.setText(Messages.getString("RenameApplicationAction_Rename"));
            rd.setMessage(Messages.getString("RenameApplicationAction_RenameText"));
            rd.setInput(a.getName());
            String newName = rd.open();
            this.data.renameApplication(a.getNr(), newName);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = super.updateSelection(selection);
        if (selection.getFirstElement() instanceof ApplicationEntry && this.data != null) {
            ApplicationEntry a = (ApplicationEntry)selection.getFirstElement();
            result = result && this.data.isApplicationValied(a.getNr());
        } else {
            result = false;
        }
        return result;
    }
}

